<?php

namespace Drupal\commerce_yabandpay\Controller;

use YaBandPay\PersiLiao\Cryptography;

require_once dirname(dirname(dirname(__FILE__))) . '/yabandpayapi/vendor/autoload.php';

/**
 * Provides the endpoint for payment notifications.
 */
class YaBandPayNotifyController{

  /**
   * Provides the "notify" page.
   *
   * Also called the "IPN", "status", "webhook" page by payment providers.
   *
   * @param \Drupal\commerce_payment\Entity\PaymentGatewayInterface $commerce_payment_gateway
   *   The payment gateway.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request.
   *
   * @return \Symfony\Component\HttpFoundation\Response
   *   The response.
   */
  public function yabandpay_notify() {

    $data = file_get_contents("php://input");  //直接返回json数据
    $dir = dirname(dirname(dirname(__FILE__)));

    $file_path = $dir."/yabandpay_config.txt";
    $str = file_get_contents($file_path);  //将整个文件内容读入到一个字符串中

    $config = json_decode($str,true);

    if($data){
        $data_arr = json_decode($data,true);  //json转数组
        //验证签名
        $yabandpay_api = new Cryptography($config['secret_key']);
        $sign_res = $yabandpay_api->verify($data_arr);
        $this->logResult($data);   //写入日志

        if($sign_res){  //签名验证成功
            $this->logResult('v3_notify_url:ok');
            echo 'ok';  //必须返回ok,不然yabanpay会一直发异步消息,直到次数发送完,详细可参考文档

            //下面对data数据做业务判断,写自己的业务逻辑即可
            $data_djson =  $data_arr['data'];
            $order_id = $data_djson['order_id'];
            $connection = \Drupal::database();
            $query = $connection->query("SELECT * FROM {commerce_order} where uuid = :uuid", [
  ':uuid' => $order_id,
]);
            $hd_info = $query->fetchAll();
            if(!$hd_info){
                $this->logResult('order_id不存在:'.$data);
                exit;
            }
            $hd_info = (array)$hd_info[0];

            if($hd_info['total_price__number'] != $data_djson['amount']){
                $this->logResult('金额不一致:'.$data);
            }

            $query_pay = $connection->query("SELECT * FROM {commerce_payment} where order_id = ".$hd_info['order_id']);
            $pay_info = $query_pay->fetchAll();
            //检测订单状态是否是已支付(pay_state = paid)
            if($pay_info && $pay_info['state'] == "paid"){
                exit;
            }else if($pay_info){
                if($data_djson['state'] == 'paid'){
                    $num_updated = $connection->update('commerce_payment')
                        ->fields([
                            'state' => 'paid',
                            'payment_gateway_mode' => $data_djson['sub_pay_method'],
                            'uuid' => $data_djson['trade_id'],
                            'amount__number' => $data_djson['amount'],
                            'amount__currency_code' => $data_djson['currency'],
                        ])
                        ->condition('order_id', $hd_info['order_id'], '=')
                        ->execute();
                }else{
                    $num_updated = $connection->update('commerce_payment')
                        ->fields([
                            'state' => $data_djson['state'],
                            'payment_gateway_mode' => $data_djson['sub_pay_method'],
                            'uuid' => $data_djson['trade_id'],
                            'amount__number' => $data_djson['amount'],
                            'amount__currency_code' => $data_djson['currency'],
                        ])
                        ->condition('order_id', $hd_info['order_id'], '=')
                        ->execute();
                }
            }else{
                $result = $connection->insert('commerce_payment')
                    ->fields([
                        'type' => $data_djson['type'],
                        'uuid' => $data_djson['trade_id'],
                        'payment_gateway' => "yabandpay",
                        'payment_gateway_mode' => $data_djson['sub_pay_method'],
                        'order_id' => $hd_info['order_id'],
                        'amount__number' => $data_djson['amount'],
                        'amount__currency_code' => $data_djson['currency'],
                        'state' => $data_djson['state'],
                        'authorized' => time(),
                        'refunded_amount__currency_code' => $data_djson['currency'],
                    ])
                    ->execute();
            }
        }else{
            $this->logResult('签名错误');
        }
    }else{

        $this->logResult('无法接收数据');
    }
    exit;
  }

    /**
     * 写日志，方便测试（看网站需求，也可以改成把记录存入数据库）
     * 注意：服务器需要开通fopen配置
     * @param $word 要写入日志里的文本内容 默认值：空值
     */
    public function logResult($word='') {
        $dir = dirname(dirname(dirname(__FILE__)))."/logs/".date('Y-m-d',time());
        if(!is_dir($dir)){
            mkdir($dir,0777,true);
        }
        $fp = fopen($dir."/".date('YmdHis',time()).'.log',"a");
        flock($fp, LOCK_EX) ;
        fwrite($fp,"执行日期：".date("Y-m-d H:i:s",time())."\n".$word."\n");
        flock($fp, LOCK_UN);
        fclose($fp);
    }

}
