<?php

namespace Drupal\commerce_yabandpay\Plugin\Commerce\PaymentGateway;

use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\OffsitePaymentGatewayBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\commerce_order\Entity\OrderInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Provides the yabandpay offsite Checkout payment gateway.
 *
 * @CommercePaymentGateway(
 *   id = "yabandpay_redirect_checkout",
 *   label = @Translation("yabandpay (Redirect to yabandpay)"),
 *   display_label = @Translation("yabandpay"),
 *    forms = {
 *     "offsite-payment" = "Drupal\commerce_yabandpay\PluginForm\RedirectCheckoutForm",
 *   },
 *   payment_method_types = {"credit_card"},
 *   credit_card_types = {
 *     "mastercard", "visa",
 *   },
 * )
 */

class RedirectCheckout extends OffsitePaymentGatewayBase{

	public function defaultConfiguration() {
	    return [
	        'secret_key' => '',
	        'user' => '',
            'display_label' => ''
	    ] + parent::defaultConfiguration();
	}


	public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
	    $form = parent::buildConfigurationForm($form, $form_state);

	    $form['secret_key'] = [
	      '#type' => 'textfield',
	      '#title' => $this->t('yabandpay secret key'),
	      '#description' => $this->t('This is the secret key from the yabandpay manager.'),
	      '#default_value' => $this->configuration['secret_key'],
	      '#required' => TRUE,
	    ];

	    $form['user'] = [
	      '#type' => 'textfield',
	      '#title' => $this->t('yabandpay user'),
	      '#description' => $this->t('This is the user from the yabandpay manager.'),
	      '#default_value' => $this->configuration['user'],
	      '#required' => TRUE,
	    ];

        $form['display_label'] = [
            '#type' => 'textfield',
            '#title' => $this->t('display name'),
            '#description' => $this->t('display name'),
            '#default_value' => $this->configuration['display_label'],
            '#required' => TRUE,
        ];

	    return $form;
	}

	public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
	    parent::submitConfigurationForm($form, $form_state);
	    $values = $form_state->getValue($form['#parents']);
	    // var_dump($values);exit;
	    $this->configuration['secret_key'] = $values['secret_key'];
	    $this->configuration['user'] = $values['user'];
	    $this->configuration['display_label'] = $values['display_label'];

        $dir = dirname(dirname(dirname(dirname(dirname(__FILE__)))));
        $fp = fopen($dir."/yabandpay_config.txt","w");
        flock($fp, LOCK_EX) ;
        fwrite($fp,'{"user":"'.$values['user'].'","secret_key":"'.$values['secret_key'].'"}');
        flock($fp, LOCK_UN);
        fclose($fp);
	}


    /**
     * {@inheritdoc}
     * 同步接收地址
     */
    public function onReturn(OrderInterface $order, Request $request) {
//        $payment_storage = $this->entityTypeManager->getStorage('commerce_payment');
//        $payment = $payment_storage->create([
//            'state' => 'authorization',
//            'amount' => $order->getBalance(),
//            'payment_gateway' => $this->entityId,
//            'order_id' => $order->id(),
//            'remote_id' => $request->query->get('txn_id'),
//            'remote_state' => $request->query->get('payment_status'),
//        ]);
//        $payment->save();
    }

}