<?php

namespace Drupal\commerce_yabandpay\PluginForm;

use Drupal\commerce_payment\Exception\PaymentGatewayException;
use Drupal\commerce_payment\PluginForm\PaymentOffsiteForm as BasePaymentOffsiteForm;
use Drupal\Core\Form\FormStateInterface;
use YaBandPay\PersiLiao\Account;
use YaBandPay\PersiLiao\Api;
use YaBandPay\PersiLiao\Cryptography;

require_once dirname(dirname(dirname(__FILE__))) . '/yabandpayapi/vendor/autoload.php';

class RedirectCheckoutForm extends BasePaymentOffsiteForm {

    /**
     * {@inheritdoc}
     */
    public function buildConfigurationForm(array $form, FormStateInterface $form_state) {

        $rooturl = $_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF'];

        $form = parent::buildConfigurationForm($form, $form_state);

        /** @var \Drupal\commerce_payment\Entity\PaymentInterface $payment */
        $payment = $this->entity;

        $payment_gateway_plugin = $payment->getPaymentGateway()->getPlugin();
        $configuration = $payment_gateway_plugin->getConfiguration();

        // Payment data.
        $data['currency'] = $payment->getAmount()->getCurrencyCode();
        $data['total'] = $payment->getAmount()->getNumber();
        $data['payment_gateway'] = $payment->getPaymentGatewayId();
        $data['order_id'] = $payment->getOrderId();

        // Form url values.
        $data['continueurl'] = $form['#return_url'];
        $data['cancelurl'] = $form['#cancel_url'];

        $connection = \Drupal::database();
        $query = $connection->query("SELECT * FROM {commerce_order_item} where order_id = :order_id", [
            ':order_id' => $data['order_id'],
        ]);
        $hd_info = $query->fetchAll();
        $product_info = (array)$hd_info[0];

        $redirect_method = 'post';
        $remove_js = ($redirect_method == 'post_manual');

        $order = $payment->getOrder();
        $order_info = array_values((array)$order)[0];

        $config_secret_key = $configuration['secret_key'];  //获取配置文件中的secret_key
        $config_user = $configuration['user'];  //获取配置文件中的user

        $yabandpay_api = new Api(
            new Account($config_user, $config_secret_key),
            new \YaBandPay\PersiLiao\Request(
                new Cryptography($config_secret_key)
            )
        );
        
        $display_method = strtolower(preg_replace('# #','',$configuration['display_label']));
        if($display_method == "alipay"){
            $pay_method = "Alipay";
        }else if($display_method == "wechatpay"){
            $pay_method = "WeChat Pay";
        }else{
            $pay_method = "YabandPay";
        }
        
        $order_id = $order_info['uuid']['x-default'];
        $amount = $data['total'];
        $currency = $data['currency'];
        $description = $product_info['title'];
        $redirect_url = $form['#return_url'];
        $notify_url = $rooturl."/commerce_yabandpay/yabandpay_notify";

        try { 
            $pay_url = $yabandpay_api->payment($pay_method, $order_id, $amount, $currency, $description, $redirect_url, $notify_url, $timeout = 0);
        }catch(\Exception $e){
            $message = array_values((array)$e)[0];
            $error_url = "https://partner.yabandpay.com/payments/error?message=".$message;
            header('Location:'.$error_url);
            exit;
        }

        if ($order->getBillingProfile()->get('address')->family_name == 'FAIL') {
            throw new PaymentGatewayException('Could not get the redirect URL.');
        }

        $form = $this->buildRedirectForm($form, $form_state, $pay_url, $data, $redirect_method);

        if ($remove_js) {
            // Disable the javascript that auto-clicks the Submit button.
            unset($form['#attached']['library']);
        }

        return $form;
    }

}
